﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Data;
using System.Configuration;

//our data access library
using DataAccess;

//MDWS web service
using MDWSLib.MDWSEmrSvc;

/// <summary>
/// CMDWSStatus class
/// </summary>
public class CMDWSStatus : CStatus
{
    /// <summary>
    /// US:838 US:840
    /// MDWS status class that derives from our CStatus class so we 
    /// handle MDWS errors in a consistent way
    /// </summary>
    /// <param name="fault"></param>
    public CMDWSStatus(FaultTO fault)
    {
        if (fault != null)
        {
            this.Status = false;
            this.StatusCode = k_STATUS_CODE.Failed;
            this.StatusComment = fault.message;
        }
    }
}